from enum import IntEnum, auto

# Enums for the inputs and outputs of the node endpoints

# EEF ##################################################################################################################

class EEFDigitalOutput(IntEnum):
    ALPHAENABLE = 0                             # ENABLE ALPHA LASER
    HTSALPHAPOWERENABLE = auto()                # ENABLE HTS ALPHA POWER
    BCRNRST = auto()                            # RESET ALL BCRS (ACTIVE LOW)
    BCR1NTRIG = auto()                          # TRIGGER BCR1 (ACTIVE LOW)
    BCR2NTRIG = auto()                          # TRIGGER BCR2 (ACTIVE LOW)
    BCREXTNTRIG = auto()                        # TRIGGER BCR_EXT (ACTIVE LOW)
    BCREXTMUX0 = auto()                         # BCR_EXT MUX SELECT INPUT 0
    BCREXTMUX1 = auto()                         # BCR_EXT MUX SELECT INPUT 1
    BCREXTMUXEN = auto()                        # BCR_EXT MUX ENABLE (ACTIVE LOW)
    FLASHHIGHPOWER = auto()                     # ENABLE FLASH HIGH POWER MODE
    FPGAENABLE = auto()                         # ENABLE FPGA POWER SUPPLY
    TECRESETAB = auto()                         # RESET PWM DRIVER OUTPUTS OF PMT1-TEC AND PMT2-TEC (ACTIVE LOW)
    TECRESETCD = auto()                         # RESET PWM DRIVER OUTPUTS OF ALPHA LASER TEC (ACTIVE LOW)
    REFENABLE = auto()                          # ENABLE REF 1 - 4
    PMT1HIGHVOLTAGEENABLE = auto()              # ENABLE HIGH VOLTAGE OF PMT1 (ACTIVE LOW)
    PMT2HIGHVOLTAGEENABLE = auto()              # ENABLE HIGH VOLTAGE OF PMT2 (ACTIVE LOW)
    PMT3HIGHVOLTAGEENABLE = auto()              # ENABLE HIGH VOLTAGE OF PMT-US-LUM (ACTIVE LOW)
    USLADCRESET = auto()                        # RESET FOR THE AD7091R-5 ADC OF THE USL BOARD (ACTIVE LOW)
    USLADCCONVERSIONSTART = auto()              # CONVERSION START FOR THE AD7091R-5 ADC OF THE USL BOARD (ACTIVE LOW)
    HTSALPHAENABLE = auto()                     # ENABLE HTS ALPHA LASER (ACTIVE LOW)
    HTSALPHATECENABLE = auto()                  # ENABLE HTS ALPHA LASER TEC
    PTBCONTROLSWITCH1 = auto()                  # PTB CONTROL SWITCH GPO2
    PTBCATHODESWITCH1 = auto()                  # PTB CATHODE SWITCH GPO2
    PTBANODESWITCH1 = auto()                    # PTB ANODE SWITCH GPO2
    PTBCONTROLSWITCH2 = auto()                  # PTB CONTROL SWITCH GPO1
    PTBCATHODESWITCH2 = auto()                  # PTB CATHODE SWITCH GPO1
    PTBANODESWITCH2 = auto()                    # PTB ANODE SWITCH GPO1
    PTBCONTROLSWITCH3 = auto()                  # PTB CONTROL SWITCH GPO0
    PTBCATHODESWITCH3 = auto()                  # PTB CATHODE SWITCH GPO0
    PTBANODESWITCH3 = auto()                    # PTB ANODE SWITCH GPO0
    USLTESTERSWITCH1 = auto()                   # USL TESTER SWITCH GPO2
    USLTESTERSWITCH2 = auto()                   # USL TESTER SWITCH GPO1
    USLTESTERSWITCH3 = auto()                   # USL TESTER SWITCH GPO0


class EEFDigitalInput(IntEnum):
    ALPHATEMPERROR = 0                          # ALPHA LASER TEMPERATURE ERROR
    BCR1LED = auto()                            # BCR1 GOOD READ LED
    BCR2LED = auto()                            # BCR2 GOOD READ LED
    BCREXTLED = auto()                          # BCR-EXT GOOD READ LED
    FPGAIRQ1 = auto()                           # FPGA IRQ1
    RESERVED1 = auto()                          # RESERVED
    FPGAIRQ3 = auto()                           # FPGA IRQ3
    FPGAIRQ4 = auto()                           # FPGA IRQ4
    FPGAIRQ5 = auto()                           # FPGA IRQ5
    FPGAIRQ6 = auto()                           # FPGA IRQ6
    FPGAIRQ7 = auto()                           # FPGA IRQ7
    FPGAIRQ8 = auto()                           # FPGA IRQ8
    INTERLOCKSTATUS = auto()                    # INTERLOCK STATUS
    INTERLOCK1 = auto()                         # INTERLOCK 1
    INTERLOCK2 = auto()                         # INTERLOCK 2
    INTERLOCK3 = auto()                         # INTERLOCK 3
    MOTOR1DIAG0 = auto()                        # MOTOR 1 DIAG0
    MOTOR1DIAG1 = auto()                        # MOTOR 1 DIAG1
    MOTOR2DIAG0 = auto()                        # MOTOR 2 DIAG0
    MOTOR2DIAG1 = auto()                        # MOTOR 2 DIAG1
    MOTOR3DIAG0 = auto()                        # MOTOR 3 DIAG0
    MOTOR3DIAG1 = auto()                        # MOTOR 3 DIAG1
    MOTOR4DIAG0 = auto()                        # MOTOR 4 DIAG0
    MOTOR4DIAG1 = auto()                        # MOTOR 4 DIAG1
    TECFAULT = auto()                           # PWM DRIVER FAULT SIGNAL OF PMT1-TEC, PMT2-TEC AND ALPHA LASER TEC (ACTIVE LOW)
    TECOTW = auto()                             # PWM DRIVER OVERTEMPERATURE SIGNAL OF PMT1-TEC, PMT2-TEC AND ALPHA LASER TEC (ACTIVE LOW)
    REFFAULT = auto()                           # FAULT REF 1 - 4
    HTSALPHATEMPERROR = auto()                  # HTS ALPHA LASER TEMPERATURE ERROR
    HTSALPHAPGOOD = auto()                      # HTS ALPHA LASER POWER GOOD
    HTSALPHATECGOOD = auto()                    # HTS ALPHA LASER TEC GOOD
    HTSALPHAPOWERFAULT = auto()                 # HTS ALPHA LASER POWER FAULT (ACTIVE LOW)
    PMT1CONVERSION = auto()                     # PMT1 CONVERSION SIGNAL
    PMT2CONVERSION = auto()                     # PMT2 CONVERSION SIGNAL


class EEFAnalogOutput(IntEnum):
    ALPHACURRENT = 0                            # ALPHA LASER CURRENT
    ALPHATEMPOUT = auto()                       # LD_TEMP
    RESERVED1 = auto()                          # RESERVED
    PMT1DISCRIMINATORLEVEL = auto()             # DISCRIMINATOR LEVEL OF PMT1
    PMT1HIGHVOLTAGESETTING = auto()             # HIGH VOLTAGE OF PMT1
    PMT2DISCRIMINATORLEVEL = auto()             # DISCRIMINATOR LEVEL OF PMT2
    PMT2HIGHVOLTAGESETTING = auto()             # HIGH VOLTAGE OF PMT2
    PMT3DISCRIMINATORLEVEL = auto()             # DISCRIMINATOR LEVEL OF PMT-US-LUM
    PMT3HIGHVOLTAGESETTING = auto()             # HIGH VOLTAGE OF PMT-US-LUM
    PMT1TEC = auto()                            # PWM OUTPUT OF PMT1-TEC
    PMT2TEC = auto()                            # PWM OUTPUT OF PMT2-TEC
    ALPHATEC = auto()                           # PWM OUTPUT OF ALPHA LASER TEC
    FPGAFLASHPOWER = auto()                     # FLASH POWER PWM OUTPUT OF THE FPGA
    FLASHFAN = auto()                           # FLASH LAMP FAN PWM OUTPUT
    HTSALPHACURRENT = auto()                    # HTS ALPHA LASER CURRENT
    HTSALPHATEC = auto()                        # HTS ALPHA LASER TEC
    USLFAN = auto()                             # USL FAN PWM OUTPUT
    RESERVETEC = auto()                         # PWM OUTPUT OF TEC-RES


class EEFAnalogInput(IntEnum):
    VREFINT = 0                                 # VREFINT (STM32F2)
    VBAT = auto()                               # VBAT (STM32F2)
    ALPHAPHOTODIODE = auto()                    # FEEDBACK PHOTO DIODE OF ALPHA LASER
    ALPHATEMPIN = auto()                        # TEMPERATURE SENSOR OF ALPHA LASER
    EXPAIN2 = auto()                            # EXPAN PIN 7
    EXPAIN3 = auto()                            # EXPAN PIN 8
    PMT1HIGHVOLTAGEMONITOR = auto()             # HIGH VOLTAGE MONITOR OF PMT1
    PMT2HIGHVOLTAGEMONITOR = auto()             # HIGH VOLTAGE MONITOR OF PMT2
    PMT3HIGHVOLTAGEMONITOR = auto()             # HIGH VOLTAGE MONITOR OF PMT-US-LUM
    PMT1TEMPA = auto()                          # TEMPERATURE SENSOR OF PMT1 (EEF REV 3)
    PMT2TEMPA = auto()                          # TEMPERATURE SENSOR OF PMT2 (EEF REV 3)
    FLASHFANTACHO = auto()                      # TACHOMETER OF FLASH LAMP FAN
    PMT3DISCRIMINATORFEEDBACK = auto()          # DISCRIMINATOR FEEDBACK OF PMT-US-LUM
    HTSALPHAPHOTODIODE = auto()                 # HTS ALPHA LASER FEEDBACK PHOTO DIODE
    HTSALPHATEMPIN = auto()                     # HTS ALPHA LASER TEMPERATURE FEEDBACK
    PMT1TEMPB = auto()                          # TEMPERATURE SENSOR OF PMT1 (EEF REV 4)
    PMT2TEMPB = auto()                          # TEMPERATURE SENSOR OF PMT2 (EEF REV 4)
    PTBCONTROLVIN0 = auto()                     # PTB DUT TP213 5VREF (SW=1) OR TP210 5.0V (SW=0)
    PTBCONTROLVIN1 = auto()                     # PTB DUT NC (SW=1) OR TP223 -12V (SW=0)
    PTBCONTROLVIN2 = auto()                     # PTB DUT TP221 6.0V (SW=1) OR TP207 3.3V (SW=0)
    PTBCONTROLVIN3 = auto()                     # PTB DUT TP200 12V (SW=1) OR TP216 5.0V (SW=0)
    PTBCATHODEVIN0 = auto()                     # PTB DUT DYNODE 4 (SW=1) OR DYNODE 5 (SW=0)
    PTBCATHODEVIN1 = auto()                     # PTB DUT DYNODE 2 (SW=1) OR DYNODE 3 (SW=0)
    PTBCATHODEVIN2 = auto()                     # PTB DUT DYNODE 6 (SW=1) OR DYNODE 7 (SW=0)
    PTBCATHODEVIN3 = auto()                     # PTB DUT CATHODE (SW=1) OR DYNODE 1 (SW=0)
    PTBANODEVIN0 = auto()                       # PTB DUT NC (SW=1) OR ANODE (SW=0)
    PTBANODEVIN1 = auto()                       # PTB DUT DYNODE 8
    PTBANODEVIN2 = auto()                       # PTB +2.5V REFERENCE
    PTBANODEVIN3 = auto()                       # PTB DUT DYNODE 9
    USLFANTACHO = auto()                        # TACHOMETER OF US-LUM FAN
    TESTBOARDAIN0 = auto()                      # EEF TEST BOARD AIN0 (RELAY1+)
    TESTBOARDAIN1 = auto()                      # EEF TEST BOARD AIN1 (RELAY2+)
    TESTBOARDAIN2 = auto()                      # EEF TEST BOARD AIN2 (RELAY3+)
    TESTBOARDAIN3 = auto()                      # EEF TEST BOARD AIN3 (RELAY4+)
    USLTESTERVIN0 = auto()                      # USL TESTER VIN0 (TEC VOLTAGE)
    USLTESTERVIN1 = auto()                      # USL TESTER VIN1 (LASER CURRENT)
    USLTESTERVIN2 = auto()                      # USL TESTER VIN2 (HIGH VOLTAGE)
    USLTESTERVIN3 = auto()                      # USL TESTER VIN3 (TEC CURRENT)


class EEFPWMOutput(IntEnum):
    PWM1 = 0                                    # EXPAN PIN 3
    PWM2 = auto()                               # EXPAN PIN 4


# MC6 ##################################################################################################################

class MC6DigitalOutput(IntEnum):
    REFENABLEA = 0                              # ENABLE REF 1 - 6
    REFENABLEB = auto()                         # ENABLE REF 7 - 12
    ENCENABLE = auto()                          # ENABLE ENC 1 - 2


class MC6DigitalInput(IntEnum):
    REF1 = 0                                    # REF1
    REF2 = auto()                               # REF2
    REF3 = auto()                               # REF3
    REF4 = auto()                               # REF4
    REF5 = auto()                               # REF5
    REF6 = auto()                               # REF6
    REF7 = auto()                               # REF7
    REF8 = auto()                               # REF8
    REF9 = auto()                               # REF9
    REF10 = auto()                              # REF10
    REF11 = auto()                              # REF11 PIN 3
    REF12 = auto()                              # REF11 PIN 4
    ENCINDEX1 = auto()                          # ENC1 INDEX | STACKER FRAME SENSOR LEFT (LED1)
    ENCA1 = auto()                              # ENC1 A     | STACKER STACK SENSOR LEFT (LED2)
    ENCB1 = auto()                              # ENC1 B
    ENCINDEX2 = auto()                          # ENC2 INDEX | STACKER FRAME SENSOR RIGHT (LED1)
    ENCA2 = auto()                              # ENC2 A     | STACKER STACK SENSOR RIGHT (LED2)
    ENCB2 = auto()                              # ENC2 B
    M1DIAG0 = auto()                            # MOTOR 1 DIAG0
    M1DIAG1 = auto()                            # MOTOR 1 DIAG1
    M2DIAG0 = auto()                            # MOTOR 2 DIAG0
    M2DIAG1 = auto()                            # MOTOR 2 DIAG1
    M3DIAG0 = auto()                            # MOTOR 3 DIAG0
    M3DIAG1 = auto()                            # MOTOR 3 DIAG1
    M4DIAG0 = auto()                            # MOTOR 4 DIAG0
    M4DIAG1 = auto()                            # MOTOR 4 DIAG1
    M5DIAG0 = auto()                            # MOTOR 5 DIAG0
    M5DIAG1 = auto()                            # MOTOR 5 DIAG1
    M6DIAG0 = auto()                            # MOTOR 6 DIAG0
    M6DIAG1 = auto()                            # MOTOR 7 DIAG1
    REFFAULTA = auto()                          # FAULT REF 1 - 6
    REFFAULTB = auto()                          # FAULT REF 7 - 12
    ENCFAULT = auto()                           # FAULT ENC 1 - 2


class MC6AnalogOutput(IntEnum):
    PLATESENSORLEFTOUTPUT = 0                   # STACKER PLATE SENSOR OUTPUT LEFT (LED2)
    PLATESENSORRIGHTOUTPUT = auto()             # STACKER PLATE SENSOR OUTPUT RIGHT (LED1)
    PWM1AOUT = auto()                           # PWM1 AND SH
    PWM2AOUT = auto()                           # PWM2
    PWM3AOUT = auto()                           # PWM3 AND EXP PIN 3
    PWM4AOUT = auto()                           # PWM4 AND EXP PIN 4


class MC6AnalogInput(IntEnum):
    VREFINT = 0                                 # VREFINT (STM32F2)
    VBAT = auto()                               # VBAT (STM32F2)
    AIN2 = auto()                               # EXP PIN 7
    AIN3 = auto()                               # EXP PIN 8
    PLATESENSORLEFTINPUT = auto()               # STACKER PLATE SENSOR INPUT LEFT
    PLATESENSORRIGHTINPUT = auto()              # STACKER PLATE SENSOR INPUT RIGHT
    PLATESENSORREFINPUT = auto()                # STACKER PLATE SENSOR INPUT REFERENCE
    HEATERTEMP = auto()                         # DISPENSER HEATER TEMPERATURE
    AINPWR = auto()                             # POWER SUPPLY


class MC6PWMOutput(IntEnum):
    PWM1 = 0                                    # PWM1 AND SH
    PWM2 = auto()                               # PWM2
    PWM3 = auto()                               # PWM3 AND EXP PIN 3
    PWM4 = auto()                               # PWM4 AND EXP PIN 4


# FMB ##################################################################################################################

class FMBDigitalOutput(IntEnum):
    PSUON = 0                                   # ENABLE THE 24 V POWER SUPPLY
    PWM1RESETAB = auto()                        # RESET THE PWM DRIVER OUTPUTS HTU AND HTL (ACTIVE LOW)
    PWM1RESETCD = auto()                        # RESET THE PWM DRIVER OUTPUTS HTB AND TEC (ACTIVE LOW)
    PWM2RESETAB = auto()                        # RESET THE PWM DRIVER OUTPUTS AV2 (ACTIVE LOW)
    PWM2RESETCD = auto()                        # RESET THE PWM DRIVER OUTPUTS AV1 (ACTIVE LOW)
    FAN1ENABLE = auto()                         # ENABLE THE 24 V SUPPLY OF FAN1
    FAN2ENABLE = auto()                         # ENABLE THE 24 V SUPPLY OF FAN2
    FANSWENABLE = auto()                        # ENABLE THE 24 V SUPPLY OF FANSW
    TACHOSEL0 = auto()                          # TACHO MUX SELECT INPUT 0
    TACHOSEL1 = auto()                          # TACHO MUX SELECT INPUT 1
    TACHOSEL2 = auto()                          # TACHO MUX SELECT INPUT 2


class FMBDigitalInput(IntEnum):
    DCOK = 0                                    # 24 V POWER SUPPLY OK
    MODE0 = auto()                              # MODE PIN 0
    MODE1 = auto()                              # MODE PIN 1
    MODE2 = auto()                              # MODE PIN 2
    MODE3 = auto()                              # MODE PIN 3
    ONBUTTON = auto()                           # FRONT PANEL ON BUTTON
    STARTBUTTON = auto()                        # FRONT PANEL START BUTTON
    LOADBUTTON = auto()                         # FRONT PANEL LOAD BUTTON
    PWM1FAULT = auto()                          # PWM DRIVER OUTPUT FAULT SIGNAL OF HTU, HTL, HTB AND TEC (ACTIVE LOW)
    PWM1OTW = auto()                            # PWM DRIVER OUTPUT OVERTEMPERATURE WARNING OF HTU, HTL, HTB AND TEC (ACTIVE LOW)
    PWM2FAULT = auto()                          # PWM DRIVER OUTPUT FAULT SIGNAL OF AV1 AND AV2 (ACTIVE LOW)
    PWM2OTW = auto()                            # PWM DRIVER OUTPUT OVERTEMPERATURE WARNING OF AV1 AND AV2 (ACTIVE LOW)
    FAN1FLAGB = auto()                          # FAN1 POWER SUPPLY FAULT SIGNAL (ACTIVE LOW)
    FAN1PGOOD = auto()                          # FAN1 POWER SUPPLY OK SIGNAL
    FAN2FLAGB = auto()                          # FAN2 POWER SUPPLY FAULT SIGNAL (ACTIVE LOW)
    FAN2PGOOD = auto()                          # FAN2 POWER SUPPLY OK SIGNAL
    FANSWFLAGB = auto()                         # FANSW POWER SUPPLY FAULT SIGNAL (ACTIVE LOW)
    FANSWPGOOD = auto()                         # FANSW POWER SUPPLY OK SIGNAL


class FMBAnalogOutput(IntEnum):
    HTU = 0                                     # PWM OUTPUT OF HTU
    HTL = auto()                                # PWM OUTPUT OF HTL
    HTB = auto()                                # PWM OUTPUT OF HTB
    TEC = auto()                                # PWM OUTPUT OF TEC
    AV2PIN2 = auto()                            # PWM OUTPUT OF AV2 PIN 2 (REV 1,2 ONLY)
    AV2PIN1 = auto()                            # PWM OUTPUT OF AV2 PIN 1 (REV 1,2 ONLY)
    AV1PIN2 = auto()                            # PWM OUTPUT OF AV1 PIN 2 (REV 1,2 ONLY)
    AV1PIN1 = auto()                            # PWM OUTPUT OF AV1 PIN 1 (REV 1,2 ONLY)
    FAN1 = auto()                               # PWM OUTPUT OF FAN1
    FAN2 = auto()                               # PWM OUTPUT OF FAN2
    FAN3 = auto()                               # PWM OUTPUT OF FAN3
    FAN4 = auto()                               # PWM OUTPUT OF FAN4
    FAN5 = auto()                               # PWM OUTPUT OF FAN5
    FAN6 = auto()                               # PWM OUTPUT OF FAN6
    FAN7 = auto()                               # PWM OUTPUT OF FAN7
    AV1 = auto()                                # PWM OUTPUT OF AV1 PARALLEL OUTPUT
    AV2 = auto()                                # PWM OUTPUT OF AV2 PARALLEL OUTPUT
    FAN8 = auto()                               # PWM OUTPUT OF FAN8
    BCR = auto()                                # BRIGHTNESS CONTROL RED
    BCG = auto()                                # BRIGHTNESS CONTROL GREEN
    BCB = auto()                                # BRIGHTNESS CONTROL BLUE
    GSR0 = auto()                               # GRAY SCALE CHANNEL R0
    GSR1 = auto()                               # GRAY SCALE CHANNEL R1
    GSR2 = auto()                               # GRAY SCALE CHANNEL R2
    GSR3 = auto()                               # GRAY SCALE CHANNEL R3
    GSG0 = auto()                               # GRAY SCALE CHANNEL G0
    GSG1 = auto()                               # GRAY SCALE CHANNEL G1
    GSG2 = auto()                               # GRAY SCALE CHANNEL G2
    GSG3 = auto()                               # GRAY SCALE CHANNEL G3
    GSB0 = auto()                               # GRAY SCALE CHANNEL B0
    GSB1 = auto()                               # GRAY SCALE CHANNEL B1
    GSB2 = auto()                               # GRAY SCALE CHANNEL B2
    GSB3 = auto()                               # GRAY SCALE CHANNEL B3


class FMBAnalogInput(IntEnum):
    EXTTEMP0 = 0                                # TEMPERATURE SENSOR TMP0
    EXTTEMP1 = auto()                           # TEMPERATURE SENSOR TMP1
    EXTTEMP2 = auto()                           # TEMPERATURE SENSOR TMP2
    EXTTEMP3 = auto()                           # TEMPERATURE SENSOR TMP3
    EXTTEMP4 = auto()                           # TEMPERATURE SENSOR TMP4
    EXTTEMP5 = auto()                           # TEMPERATURE SENSOR TMP5
    EXTTEMP6 = auto()                           # TEMPERATURE SENSOR TMP6
    EXTTEMP7 = auto()                           # TEMPERATURE SENSOR TMP7
    BOARDTEMPFMB = auto()                       # TEMPERATURE SENSOR FMB ON-BOARD
    FAN1TACHO = auto()                          # TACHOMETER OF FAN1
    FAN2TACHO = auto()                          # TACHOMETER OF FAN2
    FAN3TACHO = auto()                          # TACHOMETER OF FAN3
    FAN4TACHO = auto()                          # TACHOMETER OF FAN4
    FAN5TACHO = auto()                          # TACHOMETER OF FAN5
    FAN6TACHO = auto()                          # TACHOMETER OF FAN6
    FAN7TACHO = auto()                          # TACHOMETER OF FAN7
    ROOMTEMP = auto()                           # ROOM TEMPERATURE SENSOR
    ROOMHMD = auto()                            # ROOM HUMIDITY SENSOR
    BOARDTEMPFCN = auto()                       # TEMPERATURE SENSOR FCN ON-BOARD
    FAN8TACHO = auto()                          # TACHOMETER OF FAN8
    EXTTEMP8 = auto()                           # TEMPERATURE SENSOR TMP8 ("I2C" CONNECTOR)
    TESTBOARDAIN0 = auto()                      # FMB TEST BOARD AIN0 (HTU_2)
    TESTBOARDAIN1 = auto()                      # FMB TEST BOARD AIN1 (ADC2)
    TESTBOARDAIN2 = auto()                      # FMB TEST BOARD AIN2 (ADC3)
    TESTBOARDAIN3 = auto()                      # FMB TEST BOARD AIN3 (ADC4)


class FMBPWMOutput(IntEnum):
    pass


########################################################################################################################
